﻿using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

/** \brief ブラウザに関する名前空間 */
namespace OGSNET.Browser
{
    /** \brief カスタマイズされたWebBrowserクラス */
    class WebBrowserEx : WebBrowser
    {
        /** \brief InternetSecurityManagerを登録する */
        public WebBrowserEx()
        {
            // ブランクページを表示
            // Navigate を呼ばないと ActiveXInstance が null になってしまう
            this.Navigate("about:blank");

            this.ScriptErrorsSuppressed = true;

            // ServiceProvider の登録
            var ocxServiceProvider = this.ActiveXInstance as Com.IServiceProvider;
            object profferServicePtr;

            ocxServiceProvider.QueryService(
                ref Com.SID_SProfferService,
                ref Com.IID_IProfferService,
                out profferServicePtr
            );

            var ps = profferServicePtr as Com.IProfferServiceForIInternetSecurityManager;

            int cookie = 0;
            ps.ProfferService(
                ref Com.IID_IInternetSecurityManager, ServiceProvider.GetInstance(),
                ref cookie
            );
        }
    }

    /** \brief カスタマイズされたブラウザに実装されるIServiceProviderの実装 */
    class ServiceProvider :
        Com.IServiceProviderForIInternetSecurityManager
    {
        private static ServiceProvider instance = null; /**< 唯一のインスタンス */

        /** \brief 初期化 */
        private ServiceProvider(){
        }

        /** \brief IServiceProvider の実装 */
        public int QueryService(ref Guid guidService, ref Guid riid, out Com.IInternetSecurityManager ppvObject)
        {
            ppvObject = null;

            if (guidService == Com.IID_IInternetSecurityManager)
            {
                ppvObject = InternetSecurityManager.GetInstance();

                return Com.S_OK;
            }

            return Com.E_NOINTERFACE;
        }

        /** \brief Singleton の実装 */
        public static ServiceProvider GetInstance(){
            if (ServiceProvider.instance == null)
            {
                ServiceProvider.instance = new ServiceProvider();
            }

            return ServiceProvider.instance;
        }
    }

    /** \brief カスタマイズされたブラウザで利用されるIInternetSecurityManagerの実装 */
    class InternetSecurityManager : Com.IInternetSecurityManager
    {
        private static InternetSecurityManager instance = null; /**< 唯一のインスタンス */

        private InternetSecurityManager()
        {
        }

        /** \brief Singleton の実装 */
        public static InternetSecurityManager GetInstance()
        {
            if (InternetSecurityManager.instance == null)
            {
                InternetSecurityManager.instance = new InternetSecurityManager();
            }

            return InternetSecurityManager.instance;
        }

        public int SetSecuritySite(Com.IInternetSecurityMgrSite pSite)
        {
            return Com.INET_E_DEFAULT_ACTION;
        }

        public int GetSecuritySite(Com.IInternetSecurityMgrSite pSite)
        {
            return Com.INET_E_DEFAULT_ACTION;
        }

        public int MapUrlToZone(string pwszUrl, out int pdwZone, int dwFlags)
        {
            pdwZone = 0;

            return Com.INET_E_DEFAULT_ACTION;
        }

        public int GetSecurityId(string pwszUrl, byte[] pbSecurityId, ref uint pcbSecurityId, uint dwReserved)
        {
            return Com.INET_E_DEFAULT_ACTION;
        }

        /**
         * \brief アクションの許可、不許可を返す
         * 
         * すべてを許可する
         */
        public int ProcessUrlAction(string pwszUrl, int dwAction, out byte pPolicy, int cbPolicy, byte pContext, int cbContext, int dwFlags, int dwReserved)
        { 
            pPolicy = Com.URLPOLICY_ALLOW;

            return Com.S_OK;
        }

        public int QueryCustomPolicy(string pwszUrl, ref Guid guidKey, byte ppPolicy, int pcbPolicy, byte pContext, int cbContext, int dwReserved)
        {
            return Com.INET_E_DEFAULT_ACTION;
        }

        public int SetZoneMapping(int dwZone, string lpszPattern, int dwFlags)
        {
            return Com.INET_E_DEFAULT_ACTION;
        }

        public int GetZoneMappings(int dwZone, out System.Runtime.InteropServices.ComTypes.IEnumString ppenumString, int dwFlags)
        {
            ppenumString = null;

            return Com.INET_E_DEFAULT_ACTION;
        }
    }
}